/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.reflect;

import com.andavin.reflect.exception.UncheckedReflectiveOperationException;
import com.andavin.util.Logger;
import java.lang.reflect.AccessibleObject;

abstract class AttributeMatcher<T extends AccessibleObject, C extends AttributeMatcher> {
    private static final int SYNTHETIC = 4096;
    final Class<?> mainType;
    private final int availableModifiers;
    boolean requireExactMatch;
    int requiredModifiers;
    int disallowedModifiers;

    AttributeMatcher(Class<?> mainType, int availableModifiers) {
        this.mainType = mainType;
        this.availableModifiers = availableModifiers | 0x1000;
    }

    public C require(int ... modifiers) {
        for (int modifier : modifiers) {
            this.requiredModifiers |= modifier;
            if ((this.disallowedModifiers & modifier) == 0) continue;
            Logger.warn("Modifier {} is both required and disallowed.", Integer.toBinaryString(modifier));
        }
        this.requiredModifiers &= this.availableModifiers;
        return (C)this;
    }

    public C disallow(int ... modifiers) {
        for (int modifier : modifiers) {
            this.disallowedModifiers |= modifier;
            if ((this.requiredModifiers & modifier) == 0) continue;
            Logger.warn("Modifier {} is both required and disallowed.", Integer.toBinaryString(modifier));
        }
        this.disallowedModifiers &= this.availableModifiers;
        return (C)this;
    }

    public C requireSynthetic() {
        this.requiredModifiers |= 0x1000;
        if ((this.disallowedModifiers & 0x1000) != 0) {
            Logger.warn("Synthetic is both required and disallowed.");
        }
        return (C)this;
    }

    public C disallowSynthetic() {
        this.disallowedModifiers |= 0x1000;
        if ((this.requiredModifiers & 0x1000) != 0) {
            Logger.warn("Synthetic is both required and disallowed.");
        }
        return (C)this;
    }

    public C requireExactMatch() {
        this.requireExactMatch = true;
        return (C)this;
    }

    public abstract boolean match(T var1);

    boolean match(int modifiers, Class<?> mainType) {
        if ((this.requiredModifiers & (modifiers &= this.availableModifiers)) != this.requiredModifiers || (this.disallowedModifiers & modifiers) != 0) {
            return false;
        }
        return this.mainType == null || (this.requireExactMatch ? mainType == this.mainType : mainType.isAssignableFrom(this.mainType));
    }

    abstract UncheckedReflectiveOperationException buildException();
}

